import { StarXpandCommand } from "star-io10-web";

export class LabelSample05_For300dpi_BarbellLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(54.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(54.0, 27.0),
              new StarXpandCommand.PageModeBuilder()
                .styleHorizontalPositionTo(6.0)
                .styleVerticalPositionTo(8.0)
                .actionPrintBarcode(
                  new StarXpandCommand.Printer.BarcodeParameter(
                    "${barcode}",
                    StarXpandCommand.Printer.BarcodeSymbology.Code128,
                  )
                    .setBarDots(2)
                    .setHeight(4.0)
                    .setPrintHri(true),
                )
                .styleHorizontalPositionTo(35.0)
                .styleVerticalPositionTo(6.0)
                .actionPrintText(
                  "${product_name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    12,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                )
                .styleVerticalPositionBy(3.0)
                .styleHorizontalPositionTo(35.0)
                .actionPrintText(
                  "$${price%.2f}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    12,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                )
                .styleHorizontalPositionTo(6.0)
                .styleVerticalPositionTo(19.0)
                .actionPrintBarcode(
                  new StarXpandCommand.Printer.BarcodeParameter(
                    "${barcode}",
                    StarXpandCommand.Printer.BarcodeSymbology.Code128,
                  )
                    .setBarDots(2)
                    .setHeight(4.0)
                    .setPrintHri(true),
                )
                .styleHorizontalPositionTo(35.0)
                .styleVerticalPositionTo(17.0)
                .actionPrintText(
                  "${product_name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    12,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                )
                .styleVerticalPositionBy(3.0)
                .styleHorizontalPositionTo(35.0)
                .actionPrintText(
                  "$${price%.2f}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    12,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "barcode" : "0123456789",
    "product_name" : "PRODUCT NAME",
    "price" : 9.99
}`,
    );
  }
}
